
# HETA_versions.py
# Display versions of key libraries used for HETA

import torch
import transformers
import datasets
import sklearn
import scipy

def show_versions():
    versions = {
        "torch": torch.__version__,
        "transformers": transformers.__version__,
        "datasets": datasets.__version__,
        "scikit-learn": sklearn.__version__,
        "scipy": scipy.__version__,
    }
    for lib, ver in versions.items():
        print(f"{lib}: {ver}")
    return versions

if __name__ == "__main__":
    show_versions()
